import { IParam } from "@core/interface";
import { MainView } from "../main-view";
import { PanelViewState } from "./panel-view-state";

/**
 * 实体面板视图
 *
 * @export
 * @class PanelView
 * @extends {MainView}
 */
export class PanelView extends MainView {
    /**
     * 实体面板视图输入参数
     *
     * @type {PanelViewState}
     * @memberof PanelView
     */
    public declare state: PanelViewState;

    /**
     * 面板部件引用
     *
     * @type {IParam}
     * @memberof PanelView
     */
    public declare panel: IParam;

    /**
     * 视图初始化模块
     *
     * @memberof PanelView
     */
    public useViewInit(): void {
        super.useViewInit();
        this.panel = ref(null);
    }

    /**
     * 安装视图所有功能模块
     *
     * @return {*} 
     * @memberof PanelView
     */
    public moduleInstall() {
        const superParams = super.moduleInstall();
        return {
            ...superParams,
            panel: this.panel
        };
    }
}